//	TorusGamesCallbacks-iOS.m
//
//	A few platform-dependent functions that the platform-independent code
//	will call to access user interface objects.
//
//	© 2021 by Jeff Weeks
//	See TermsOfUse.txt

#import "TorusGames-Common.h"
#import "GeometryGamesUtilities-Mac-iOS.h"
#import "GeometryGamesUtilities-Common.h"
#import "GeometryGamesColorSpaces.h"
#import "TorusGamesRootController.h"


void SetTorusGamesStatusMessage(
	const Char16	*aText,	//	zero-terminated UTF-16 string
	ColorP3Linear	aColorP3Linear,
	GameType		aGame)
{
#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= __IPHONE_13_0)
#warning Once Torus Games requires iOS 13.0 or higher, \
we may eliminate the "else" part below.
#endif

	//	Note:  The function SetHyperbolicGamesStatusMessage()
	//	in the Hyperbolic Games app offers an alternative way
	//	to set the status message, which would make this function
	//	slightly simpler at the cost of making the TorusGamesAppDelegate
	//	slightly more complicated.

	TorusGamesRootController	*theTorusGamesRootController = nil;
	
	if (@available(iOS 13.0, *))
	{
		NSSet<UIScene *>	*theConnectedScenes;
		UIScene				*theScene;
		UIWindowScene		*theWindowScene;
		NSArray<UIWindow *>	*theWindows;
		UIViewController	*theRootViewController;
	
		theConnectedScenes = [[UIApplication sharedApplication] connectedScenes];
		
		//	Torus Games supports only one UIScene.
		//	If it supported multiple UIScenes, things would get more complicated.
		if ([theConnectedScenes count] == 1)
		{
			theScene = [theConnectedScenes anyObject];
			if ([theScene isKindOfClass:[UIWindowScene class]])
			{
				theWindowScene = (UIWindowScene *) theScene;
				theWindows = [theWindowScene windows];
				for (UIWindow *theWindow in theWindows)
				{
					theRootViewController = [theWindow rootViewController];
					if ([theRootViewController isKindOfClass:[TorusGamesRootController class]])
					{
						theTorusGamesRootController = (TorusGamesRootController *) theRootViewController;
						break;
					}
				}
			}
		}
	}
	else
	{
		UIWindow			*theWindow;
		UIViewController	*theRootViewController;

		theWindow = [[UIApplication sharedApplication] keyWindow];
		theRootViewController = [theWindow rootViewController];
		if ([theRootViewController isKindOfClass:[TorusGamesRootController class]])
			theTorusGamesRootController = (TorusGamesRootController *) theRootViewController;
	}

	[theTorusGamesRootController
		setMessageText:	GetNSStringFromZeroTerminatedString(aText)
		forGame:		aGame];

	[theTorusGamesRootController setMessageColor:
		//	colorWithDisplayP3Red:green:blue:alpha: takes gamma-encoded color components
		[UIColor colorWithDisplayP3Red:	GammaEncode(aColorP3Linear.r)
								 green:	GammaEncode(aColorP3Linear.g)
								  blue:	GammaEncode(aColorP3Linear.b)
								 alpha:	aColorP3Linear.a]];
}
